import viz
viz.go()

NUM_BOXES = 10

import viznet

#Generate network event IDs
CLIENT_MOUSE_MOVE	= viznet.id('ClientMouseMove')
CLIENT_MOUSE_DOWN	= viznet.id('ClientMouseDown')
CLIENT_MOUSE_UP		= viznet.id('ClientMouseUp')
CLIENT_ADD_GRABBER	= viznet.id('ClientAddGrabber')
CLIENT_DEL_GRABBER	= viznet.id('ClientDelGrabber')
CLIENT_UPDATE		= viznet.id('ClientUpdate')

#Start server
viznet.server.start()

import Grabber

def onClientMove(e):
	g = Grabber.getGrabber(e.sender)
	if g:
		g.setMousePosition(e.pos,e.line)
viz.callback(CLIENT_MOUSE_MOVE,onClientMove)

def onClientDown(e):
	g = Grabber.getGrabber(e.sender)
	if g:
		g.release()
		info = viz.intersect(e.line.begin,e.line.end)
		if info.valid and info.object in boxes:
			g.grab(info.object,info.point,e.line.begin)
viz.callback(CLIENT_MOUSE_DOWN,onClientDown)

def onClientUp(e):
	g = Grabber.getGrabber(e.sender)
	if g:
		g.release()
viz.callback(CLIENT_MOUSE_UP,onClientUp)

def onStartClient(e):
	#Send existing grabbers to client
	names = Grabber.getGrabberNames()
	for n in names:
		viznet.server.sendClient(e.sender,CLIENT_ADD_GRABBER,name=n)
	#Add new grabber for client
	Grabber.addGrabber(e.sender)
	#Send new grabber to all clients
	viznet.server.send(CLIENT_ADD_GRABBER,name=e.sender)
	print '** Client joined:',e.sender
	
def onStopClient(e):
	#Remove grabber for client
	Grabber.removeGrabber(e.sender)
	#Remove grabber on client machines
	viznet.server.send(CLIENT_DEL_GRABBER,name=e.sender)
	print '** Client left:',e.sender
	
viz.callback(viznet.CLIENT_CONNECT_EVENT,onStartClient)
viz.callback(viznet.CLIENT_DISCONNECT_EVENT,onStopClient)

def onUpdate():
	boxdata = [ (b.getPosition(),b.getQuat()) for b in boxes ]
	grabdata = {}
	for n,g in Grabber.iterGrabbers():
		grabdata[n] = (g.pos,g.bLine,g.eLine,g.isGrabbing())
	viznet.server.send(CLIENT_UPDATE,boxdata=boxdata,grabdata=grabdata)
vizact.onupdate(0,onUpdate)

#Initialize view/window settings
viz.MainView.setPosition(0,7,-20)
viz.MainView.lookat(0,0,0)
viz.MainWindow.clearcolor(viz.SKYBLUE)
viz.mouse(0)

#Create ground plane
ground = viz.add('tut_ground.wrl')

#Add a bunch of boxes to the physics simulation
boxes = []
for x in range(NUM_BOXES):
	box = viz.add('box.wrl')
	boxes.append(box)


###########################################
# Enable physics on server
###########################################
viz.phys.enable()
ground.collidePlane()

for b in boxes:
	b.collideBox()

def reset():
	for i,b in enumerate(boxes):
		b.reset()
		b.rotate(0,1,0,0)
		b.translate(vizmat.GetRandom(-0.5,0.5),i*2+10,vizmat.GetRandom(-0.5,0.5))
reset()

vizact.onkeydown('r',reset)
###########################################
